---
title: Terraform · Cloudflare API Shield docs
description: Get started with API Shield using Terraform from the examples
  below. For more information on how to use Terraform with Cloudflare, refer to
  the Terraform documentation.
lastUpdated: 2025-08-20T16:33:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/api-shield/reference/terraform/
  md: https://developers.cloudflare.com/api-shield/reference/terraform/index.md
---

Get started with API Shield using Terraform from the examples below. For more information on how to use Terraform with Cloudflare, refer to the [Terraform documentation](https://developers.cloudflare.com/terraform/).

The following resources are available to configure through Terraform:

**Session identifiers**

* [`api_shield`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_shield) for configuring session identifiers in API Shield.

**Endpoint Management**

* [`api_shield_operation`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_shield_operation) for configuring endpoints in Endpoint Management.

**Schema validation 2.0**

* [`api_shield_schema`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_shield_schema) for configuring a schema in [Schema validation 2.0](https://developers.cloudflare.com/api-shield/security/schema-validation/).
* [`api_shield_schema_validation_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_shield_schema_validation_settings) for configuring zone-level Schema validation 2.0 settings.
* [`api_shield_operation_schema_validation_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_shield_operation_schema_validation_settings) for configuring operation-level Schema validation 2.0 settings.

## Manage API Shield session identifiers

Refer to the example configuration below to set up [session identifiers](https://developers.cloudflare.com/api-shield/get-started/#to-set-up-session-identifiers) on your zone.

```tf
resource "cloudflare_api_shield" "my_api_shield" {
  zone_id  = var.zone_id
  auth_id_characteristics {
    name = "authorization"
    type = "header"
  }
}
```

## Manage API Shield Endpoint Management

Refer to the example configuration below to [manage endpoints](https://developers.cloudflare.com/api-shield/management-and-monitoring/) on your zone.

```tf
resource "cloudflare_api_shield_operation" "get_image" {
  zone_id  = var.zone_id
  method   = "GET"
  host     = "example.com"
  endpoint = "/api/images/{var1}"
}


resource "cloudflare_api_shield_operation" "post_image" {
  zone_id  = var.zone_id
  method   = "POST"
  host     = "example.com"
  endpoint = "/api/images/{var1}"
}
```

## Manage Schema validation 2.0

Note

It is required to configure Endpoint Management if you want to set up Schema validation 2.0 using Terraform.

Refer to the example configuration below to manage [Schema validation 2.0](https://developers.cloudflare.com/api-shield/security/schema-validation/api/) on your zone.

```tf
# Schema that should be used for Schema validation 2.0
resource "cloudflare_api_shield_schema" "example_schema" {
  zone_id                   = var.zone_id
  name                      = "example-schema"
  kind                      = "openapi_v3"
  validation_enabled        = true
  source                    = file("./schemas/example-schema.json")
}


# Block all requests that violate schema by default
resource "cloudflare_api_shield_schema_validation_settings" "zone_level_settings" {
  zone_id                               = var.zone_id
  validation_default_mitigation_action  = "block"
}


# For endpoint post_image - only log requests that violate schema
resource "cloudflare_api_shield_operation_schema_validation_settings" "post_image_log_only" {
  zone_id           = var.zone_id
  operation_id      = cloudflare_api_shield_operation.post_image.id
  mitigation_action = "log"
}
```
