---
title: Subaddressing support in Email Routing · Changelog
description: Subaddressing, also known as plus addressing, is now supported in
  Email Routing.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-07-21-subaddressing/
  md: https://developers.cloudflare.com/changelog/2025-07-21-subaddressing/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Subaddressing support in Email Routing

Jul 21, 2025

[Email Routing](https://developers.cloudflare.com/email-routing/)

Subaddressing, as defined in [RFC 5233](https://www.rfc-editor.org/rfc/rfc5233), also known as plus addressing, is now supported in Email Routing. This enables using the "+" separator to augment your custom addresses with arbitrary detail information.

Now you can send an email to `user+detail@example.com` and it will be captured by the `user@example.com` custom address. The `+detail` part is ignored by Email Routing, but it can be captured next in the processing chain in the logs, an [Email Worker](https://developers.cloudflare.com/email-routing/email-workers/) or an [Agent application](https://github.com/cloudflare/agents/tree/main/examples/email-agent).

Customers can use this feature to dynamically add context to their emails, such as tracking the source of an email or categorizing emails without needing to create multiple custom addresses.

![Subaddressing](https://developers.cloudflare.com/_astro/subaddressing.x65bljxx_Z1DjNfi.webp)

Check our [Developer Docs](https://developers.cloudflare.com/email-routing/setup/email-routing-addresses/#subaddressing) to learn on to enable subaddressing in Email Routing.
