---
title: WAF Release - 2025-09-29 · Changelog
description: Cloudflare WAF managed rulesets 2025-09-29 release
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-09-29-waf-release/
  md: https://developers.cloudflare.com/changelog/2025-09-29-waf-release/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## WAF Release - 2025-09-29

Sep 29, 2025

[WAF](https://developers.cloudflare.com/waf/)

This week highlights four important vendor- and component-specific issues: an authentication bypass in SimpleHelp (CVE-2024-57727), an information-disclosure flaw in Flowise Cloud (CVE-2025-58434), an SSRF in the WordPress plugin Ditty (CVE-2025-8085), and a directory-traversal bug in Vite (CVE-2025-30208). These are paired with improvements to our generic detection coverage (SQLi, SSRF) to raise the baseline and reduce noisy gaps.

**Key Findings**

* SimpleHelp (CVE-2024-57727): Authentication bypass in SimpleHelp that can allow unauthorized access to management interfaces or sessions.

* Flowise Cloud (CVE-2025-58434): Information-disclosure vulnerability in Flowise Cloud that may expose sensitive configuration or user data to unauthenticated or low-privileged actors.

* WordPress:Plugin: Ditty (CVE-2025-8085): SSRF in the Ditty WordPress plugin enabling server-side requests that could reach internal services or cloud metadata endpoints.

* Vite (CVE-2025-30208): Directory-traversal vulnerability in Vite allowing access to filesystem paths outside the intended web root.

**Impact**

These vulnerabilities allow attackers to gain access, escalate privileges, or execute actions that were previously unavailable:

* SimpleHelp (CVE-2024-57727): An authentication bypass that can let unauthenticated attackers access management interfaces or hijack sessions — enabling lateral movement, credential theft, or privilege escalation within affected environments.

* Flowise Cloud (CVE-2025-58434): Information-disclosure flaw that can expose sensitive configuration, tokens, or user data; leaked secrets may be chained into account takeover or privileged access to backend services.

* WordPress:Plugin: Ditty (CVE-2025-8085): SSRF that enables server-side requests to internal services or cloud metadata endpoints, potentially allowing attackers to retrieve credentials or reach otherwise inaccessible infrastructure, leading to privilege escalation or cloud resource compromise.

* Vite (CVE-2025-30208): Directory-traversal vulnerability that can expose filesystem contents outside the web root (configuration files, keys, source code), which attackers can use to escalate privileges or further compromise systems.

| Ruleset | Rule ID | Legacy Rule ID | Description | Previous Action | New Action | Comments |
| - | - | - | - | - | - | - |
| Cloudflare Managed Ruleset | 6fe90532af50427484a5275c8c2e30fb | 100717 | SimpleHelp - Auth Bypass - CVE:CVE-2024-57727 | Log | Block | This rule is merged to 100717 in legacy WAF and 498fcd81a62a4b5ca943e2de958094d3 in new WAF |
| Cloudflare Managed Ruleset | 013ef5de3f074fd5a43cdd70d58b886b | 100775 | Flowise Cloud - Information Disclosure - CVE:CVE-2025-58434 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 68fc5c086ccb4b40a35a63b19bce1ff4 | 100881 | WordPress:Plugin:Ditty - SSRF - CVE:CVE-2025-8085 | Log | Block | This is a New Detection |
| Cloudflare Managed Ruleset | 9e1a56e6b3bc49b187bf6e35ddc329dd | 100887 | Vite - Directory Traversal - CVE:CVE-2025-30208 | Log | Block | This is a New Detection |
