---
title: How Challenges work · Cloudflare challenges docs
description: Challenges can be issued in three primary ways depending on which
  Cloudflare products or features are in use. Each method is designed to balance
  security with seamless visitor experience.
lastUpdated: 2025-07-14T15:47:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/concepts/how-challenges-work/
  md: https://developers.cloudflare.com/cloudflare-challenges/concepts/how-challenges-work/index.md
---

Challenges can be issued in three primary ways depending on which Cloudflare products or features are in use. Each method is designed to balance security with seamless visitor experience.

| Product | Challenge type(s) |
| - | - |
| [WAF](https://developers.cloudflare.com/waf/) ([custom rules](https://developers.cloudflare.com/waf/custom-rules/), [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/), [IP access rules](https://developers.cloudflare.com/waf/tools/ip-access-rules/)) | [Interstitial Challenge Page](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/) |
| [Bot Management](https://developers.cloudflare.com/bots/get-started/bot-management/) | [JavaScript Detections](https://developers.cloudflare.com/bots/additional-configurations/javascript-detections/) |
| [Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/bot-fight-mode/), [Super Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/) | [Interstitial Challenge Page](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/) |
| [Turnstile](https://developers.cloudflare.com/turnstile/) | Embedded widget |
| [HTTP DDoS attack protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/) | Any Challenge |
| [Under Attack Mode](https://developers.cloudflare.com/fundamentals/reference/under-attack-mode/) | [Managed Challenge](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/#managed-challenge-recommended) |

Challenge Pages and Turnstile rely on the same underlying mechanism to issue Challenges to your website or application's visitors.

JavaScript Detections supports Cloudflare's Enterprise Bot Management. While it still relies on client-side detections, JavaScript Detections function using a more performant challenge logic than Challenge Pages or Turnstile.

***

## Available Challenges

Refer to the following pages for more information on the different challenge types:

* [Interstitial Challenge Pages](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/)
* [Turnstile](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/turnstile/)
* [JavaScript Detections](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/javascript-detections/)

***

## Limitations

Cloudflare Challenges cannot support the following:

* [Browser extensions](https://developers.cloudflare.com/cloudflare-challenges/reference/supported-browsers/#browser-extensions) that modify the browser's `User-Agent` value or Web APIs such as `Canvas` and `WebGL`.
* Implementations where a domain serves a challenge page originally requested for another domain.
* Challenge Pages cannot be embedded in cross-origin iframes.
* Client software where the solve request of a Managed Challenge comes from a different IP than the original IP a Challenge request was issued to. For example, if you receive the Challenge from one IP and solve it using another IP, the solve is not valid and you may encounter a Challenge loop.
