---
title: Email Security · Cloudflare Zero Trust docs
description: Email Security is the practice of protecting your email inbox from
  cyber attacks and unwanted communication sent via email.
lastUpdated: 2025-10-24T15:44:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/index.md
---

Important

Refer to [Area 1](https://developers.cloudflare.com/email-security/) if you are looking for the Area 1 documentation.

Note

If you have not yet purchased Email Security, you can try Email Security with Retro Scan. Refer to [Retro Scan](https://developers.cloudflare.com/cloudflare-one/email-security/retro-scan/) to learn more.

Protect your email inbox with Email Security.

Email Security is the practice of protecting your email inbox from cyber attacks and unwanted communication sent via email.

Cloudflare's Email Security uses Artificial Intelligence (AI), threat intelligence, and expert security rules to analyze every incoming email.

Email Security protects your email inbox from phishing attacks, malware, [Business Email Compromise](https://www.cloudflare.com/en-gb/learning/email-security/business-email-compromise-bec/) attacks, and vendor email fraud.

Cloudflare's Email Security integrates with your existing email provider (such as Microsoft 365 or Gmail), and reduces the amount of spam and phishing emails landing in your inbox. You can configure Email Security via [API](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/), [BCC](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/bcc-setup/gmail-bcc-setup/gmail-bcc-setup/)/[Journaling](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/), or [MX/Inline](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/mx-inline-deployment-setup/) deployment. All three deployments aim at protecting your organization from malicious activities.

When you complete the [setup process](https://developers.cloudflare.com/cloudflare-one/email-security/setup/), the Cloudflare dashboard will display the Email Security overview page.

The Email Security overview provides you with:

* **Quick actions**, where you can:

  * View [reclassifications](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#reclassify-messages)
  * Manage detection settings: manage [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/allow-policies/), [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/blocked-senders/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/trusted-domains/), [impersonation registry](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/impersonation-registry/) and [additional detections](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/additional-detections/).
  * [Run screens](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/search-email/#screen-criteria)

* **Recommendations**: A series of recommendations. For example, you may be recommended to learn how to submit emails for reclassification, create policies, or protect users at risk of [impersonation](https://developers.cloudflare.com/cloudflare-one/email-security/detection-settings/impersonation-registry/)

* **Email Security metrics**: Activity from the last seven days.

* **Recently modified policies** A list of modified policies.

* **Education and resources**: Links to [implementation guides](https://developers.cloudflare.com/cloudflare-one/implementation-guides/), [Email Security changelogs](https://developers.cloudflare.com/cloudflare-one/changelog/email-security/), and [API documentation](https://developers.cloudflare.com/api/resources/email_security/subresources/investigate/methods/get/)

To access the Email Security overview:

1. Log in to [Zero Trust](https://one.dash.cloudflare.com/).
2. Go to **Email Security** > **Overview**.
