---
title: Microsoft 365 journaling setup · Cloudflare Zero Trust docs
description: "When you receive an email, the email lands on your Microsoft 365
  inbox, and then Email Security receives a copy of that email. The following
  email flow shows how this works:"
lastUpdated: 2025-10-08T14:57:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/index.md
---

When you receive an email, the email lands on your Microsoft 365 inbox, and then Email Security receives a copy of that email. The following email flow shows how this works:

![Email flow when setting up Microsoft 365 with Email Security.](https://developers.cloudflare.com/_astro/Email_Security_MS365_Journaling_Diagram.BkS1qUH0_2gAWGT.webp)

To enable Microsoft 365 journaling deployment:

1. Log in to [Zero Trust](https://one.dash.cloudflare.com/) > **Email Security**.
2. Select **Overview**. If you have not purchased Email Security, select **Contact Sales**. Otherwise, select **Set up** > **BCC/Journaling**.
3. Select **Integrate with MS** > **Authorize**.
4. Continue with [Integrate with Microsoft 365](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/#1-integrate-with-microsoft-365) to connect your Microsoft integration.

## 1. Integrate with Microsoft 365

To integrate with Microsoft 365:

1. **Name integration**: Add your integration name, then select **Continue**.

2. **Authorize integration**:

   * Select **Authorize**. Selecting **Authorize** will take you to the **Microsoft Sign in** page where you will have to enter your email address.
   * Once you enter your email address, select **Next**.
   * After selecting **Next**, the dashboard will show you a dialog box with a list of requested permissions. Select **Accept to authorize Email Security**. Upon authorization, you will be redirected to a page where you can review details and enroll the integration.

3. **Review details**: Review your integration details, then:

   * Select **Complete Email Security set up** where you will be able to connect your domains and configure auto-moves.
   * Select **Continue to Email Security**.

Continue with [Connect your domains](#connect-your-domains) for the next steps.

### Connect your domains

On the **Set up Email Security** page:

1. **Connect domains**: Select at least one domain. Then, select **Continue**.
2. (**Optional**) **Add manual domains**: Select **Add domain name** to manually enter additional domains. Then, select **Continue**.
3. (**Optional**) **Adjust hop count**: Enter the number of hops. Then, select **Continue**.
4. (**Optional**, select **Skip for now** to skip this step) **Move messages**: Refer to [Auto-moves](https://developers.cloudflare.com/cloudflare-one/email-security/auto-moves/) to configure auto-moves. Then, select **Continue**.
5. **Select your processing location**: Configure where you want Cloudflare to process your email. **Global** will be the default option. If you choose **Global**, `<account tag>@CF-emailsecurity.com` will be your regional service address. Once you have chosen your processing location, select **Continue**.
6. **Review details**: Review your connected domains and service addresses. Then, select **Go to domains.**

Your domains are now added successfully.

To view your connected domains:

1. Go to **Settings**.
2. Locate your domain, select the three dots > **View domain**. Selecting **View domain** will display information about your domain.

## 2. Configure journal rule

1. Log in to the [Microsoft Purview compliance portal](https://compliance.microsoft.com/homepage).

2. On the sidebar, go to **Settings** (the gear icon) > **Data Lifecycle Management** > **Exchange (legacy)**.

3. In **Send undeliverable journal reports to** enter the email address of a valid user account. Note that you cannot use a team or group address. Select **Save** once you entered the email address.

4. On the sidebar, go to **Solutions** > **Data Lifecycle Management** > **Exchange (legacy)**.

5. Select **Journal rules**.

6. Select **New rule** to configure a journaling rule, and configure it as follows:

   * **Send journal reports to**: This is the address you copied and pasted in step 5 of [Connect your domains](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/#connect-your-domains).
   * **Journal rule name**: `Journal Messages to Email Security`
   * **Journal messages sent or received from**: *Everyone*
   * **Type of message to journal**: *External messages only*

7. Select **Next**.

8. Verify the information is correct, and select **Submit** > **Done**.

Once saved, the rule is automatically active. However, it may take a few minutes for the configuration to propagate and start pushing messages to Email Security. After it propagates, you can [monitor your inbox](https://developers.cloudflare.com/cloudflare-one/email-security/email-monitoring/) in the Cloudflare dashboard to check the number of messages processed. This number will grow as journaled messages are sent to Email Security from your Exchange server.

## Verify successful deployment

To verify that the deployment has been successful and that your emails are being scanned:

1. In [Zero Trust](https://one.dash.cloudflare.com/), select **Email Security**.
2. Go to **Settings** > **Domain management** > **Domains**, then select **View**.
3. Under **Your domains**, locate your domain, and verify that **Status** (which describes the state of the configuration) displays **Active**.

## Next steps

[Enable logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/enable-logs/) to send detection data to an endpoint of your choice.
