---
title: Egress IPs · Cloudflare Zero Trust docs
description: When you set up Email Security using an MX/Inline deployment, your
  existing email provider will accept messages coming from Email Security's
  egress IP addresses.
lastUpdated: 2025-06-30T10:06:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/egress-ips/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/egress-ips/index.md
---

When you set up Email Security using an [MX/Inline deployment](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/mx-inline-deployment/), your existing email provider will accept messages coming from Email Security's egress IP addresses.

Setting up egress IPs allows Cloudflare to deliver emails to your inbox.

Refer to this page for reference on what IP subnet mask ranges to use.

Additional information for Microsoft 365

Microsoft 365 does not support IPv6 addresses nor the following IPv4 subnet mask ranges:

* `104.30.32.0/19`
* `134.195.26.0/23`

If you use Microsoft 365, you will have to use the broken down `/24` subnet mask IP addresses. Refer to [Microsoft 365 `/24` addresses](#microsoft-365-24-addresses) for a list of supported IPv4 addresses.

### IPv4

```txt
52.11.209.211
52.89.255.11
52.0.67.109
54.173.50.115
104.30.32.0/19
158.51.64.0/26
158.51.65.0/26
134.195.26.0/23
35.157.195.63
52.58.35.43
```

### IPv6

```txt
2405:8100:c400::/38
```

## Microsoft 365 `/24` addresses

Use these IPv4 addresses for Microsoft 365, instead of the `/19` and `/23` subnets:

```txt
104.30.32.0/24
104.30.33.0/24
104.30.34.0/24
104.30.35.0/24
104.30.36.0/24
104.30.37.0/24
104.30.38.0/24
104.30.39.0/24
104.30.40.0/24
104.30.41.0/24
104.30.42.0/24
104.30.43.0/24
104.30.44.0/24
104.30.45.0/24
104.30.46.0/24
104.30.47.0/24
104.30.48.0/24
104.30.49.0/24
104.30.50.0/24
104.30.51.0/24
104.30.52.0/24
104.30.53.0/24
104.30.54.0/24
104.30.55.0/24
104.30.56.0/24
104.30.57.0/24
104.30.58.0/24
104.30.59.0/24
104.30.60.0/24
104.30.61.0/24
104.30.62.0/24
104.30.63.0/24
134.195.26.0/24
134.195.27.0/24
```
