---
title: Connect private network to Internet · Cloudflare Zero Trust docs
description: This guide covers how to connect a private network to the Internet
  using WARP Connector. In this example, we will create a WARP Connector for
  subnet 10.0.0.0/24 and install it on 10.0.0.1.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-connector/site-to-internet/index.md
---

This guide covers how to connect a private network to the Internet using WARP Connector. In this example, we will create a WARP Connector for subnet `10.0.0.0/24` and install it on `10.0.0.1`.

```mermaid
    flowchart LR
      subgraph subnet1[Subnet 10.0.0.0/24]
        device1["Device
        10.0.0.2"]-->router1["WARP Connector
        10.0.0.1"]
      end
      router1-->C((Cloudflare))-->I{Internet}
```

## Prerequisites

* A Linux host [1](#user-content-fn-1) on the subnet
* Verify that your firewall allows inbound/outbound traffic over the [WARP IP addresses, ports, and domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).

## 1. Install a WARP Connector

To install WARP Connector on a host machine:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Networks** > **Tunnels**.

2. Select **Create a tunnel**.

3. For the tunnel type, select **WARP Connector**.

4. You will be prompted to turn on **Warp to Warp** and [**Override local interface IP**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#override-local-interface-ip) if they are currently turned off. These settings allow Cloudflare to assign a unique CGNAT IP to each WARP device and route traffic between them.

5. Give the tunnel any name (for example, `Subnet-10.0.0.0/24`) and select **Create tunnel**.

6. Select the operating system of your host machine.

7. On your host machine, open a terminal window and run the commands shown in the Zero Trust dashboard. Those commands will install the WARP Connector, enable IP forwarding on the host, and connect WARP Connector to your Zero Trust organization.

   Remote SSH connections

   If you are managing the deployment remotely over SSH, your connection may drop when you install the WARP Connector. Because the WARP connector immediately starts forwarding traffic to Cloudflare, the remote SSH server's traffic will now route via Cloudflare instead of via the server's public IP. To work around the issue:

   * **Option 1**: In your WARP Connector [device profile](#2-recommended-create-a-device-profile), temporarily add the public IP of your local machine to the [Split Tunnel Exclude list](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/).

   * **Option 2**: If your local machine is connected to Zero Trust (for example, via the WARP client), you can SSH to the CGNAT IP of the WARP Connector. Traffic to the CGNAT IP must route through the WARP tunnel.

8. (Optional) Configure IP forwarding:

   Enable IP forwarding to persist after reboot

   ```sh
   echo 'net.ipv4.ip_forward = 1' | sudo tee -a /etc/sysctl.d/99-warp-svc.conf
   sudo sysctl -p /etc/sysctl.d/99-warp-svc.conf
   ```

   Configure IP forwarding with iptables

   If you are setting up WARP Connector on a host with iptables enabled, make sure that your iptables FORWARD chain includes rules to accept the desired traffic. For testing and troubleshooting purposes, you can set the default policy for the WARP interface to ACCEPT:

   ```sh
   iptables -A FORWARD -i CloudflareWARP -J ACCEPT
   iptables -A FORWARD -o CloudflareWARP -J ACCEPT
   ```

9. To verify that the WARP Connector is connected to Cloudflare:

   ```sh
   $ warp-cli status
   Status update: Connected
   ```

   Troubleshoot connection

   If WARP is disconnected, try the following troubleshooting strategies:

   * Run `warp-cli connect`.

   * If your private network uses a firewall to restrict Internet traffic, ensure that it allows the [WARP ports and IPs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/).

   * Review your [WARP daemon logs](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/warp-logs/) for information about why the connection is failing.

WARP Connector software is now installed but not yet routing traffic.

## 2. (Recommended) Create a device profile

A dedicated [device profile](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/) allows you to manage the WARP Connector host machine separately from WARP client user devices. WARP Connector hosts are registered to your Zero Trust organization with the email address `warp_connector@<your-team-name>.cloudflareaccess.com`. To set up a device profile for WARP Connector:

1. [Create a new profile](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/device-profiles/#create-a-new-profile) that matches on the following expression:

   | Selector | Operator | Value |
   | - | - | - |
   | User email | is | `warp_connector@<your-team-name>.cloudflareaccess.com` |

2. In the profile settings, ensure that **Service mode** is set to **Gateway with WARP**.

Note

`warp_connector@<your-team-name>.cloudflareaccess.com` will only match WARP Connectors deployed with WARP client version `2024.9.346.0` and above. WARP Connectors deployed using the legacy workflow will use the generic email for service token registrations (`non-identity@<your-team-name>.cloudflareaccess.com`).

## 3. Route traffic from subnet to WARP Connector

The WARP Connector host will automatically forward DNS and network traffic to Cloudflare. Depending on where you installed the WARP Connector, you may need to configure other devices on the subnet to route outbound requests through WARP Connector.

### Option 1: Default gateway

If you installed WARP Connector on your router, no additional configuration is necessary. All traffic will use the router as the default gateway.

![Default gateway routing configuration](https://developers.cloudflare.com/_astro/default-gateway.BVYB18Ze_Z1PhWIA.webp)

### Option 2: Alternate gateway

If you have access to the router but installed WARP Connector on another machine, you can configure the router to forward traffic to the WARP Connector. This typically involves adding a static route for the destination IPs that you want to connect to through Cloudflare. Refer to your router documentation for specific instructions on how to add an IP route.

![Alternate gateway routing configuration](https://developers.cloudflare.com/_astro/alternate-gateway.qFF4NOVp_Z2mO45W.webp)

#### Add IP route to router

For example, for all traffic from the subnet to egress through WARP Connector, add a rule on the router that routes `0.0.0.0` to the WARP Connector host machine (`10.0.0.100`).

When a device on the subnet sends a request, the router will first redirect the traffic to the WARP Connector host. WARP Connector encrypts the traffic, changes its destination IP to the [WARP ingress IP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#warp-ingress-ip), and sends it back to the router. The router will now forward this encrypted traffic to Cloudflare.

Note

Ensure that your routing rules do not forward the [WARP ingress IP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#warp-ingress-ip) back to the WARP Connector.

#### Configure DNS resolver on router

To forward DNS traffic from the subnet to Cloudflare Gateway, your router should point DNS queries to the shared IP addresses for the Gateway DNS resolver:

* `172.64.36.1`
* `172.64.36.2`

You will also need to [add an IP route](#add-ip-route-to-router) which routes these Gateway resolver IPs to the WARP Connector host machine.

### Option 3: Intermediate gateway

If you do not have access to the router, you will need to configure each device on the subnet to egress through the WARP Connector machine instead of the default gateway.

![Intermediate gateway routing configuration](https://developers.cloudflare.com/_astro/intermediate-gateway.RihbfwSx_2pXfUQ.webp)

#### Add IP route to devices

You can configure all traffic on a device to egress through WARP Connector with its local source IP. All traffic will be filtered by your Gateway network policies.

* Linux

  ```sh
  sudo ip route add default via <WARP-CONNECTOR-IP> dev eth0 metric 101
  ```

  Ensure that the `metric` value is lower than other default gateways.

* macOS

  ```sh
  sudo route -n change default <WARP-CONNECTOR-IP> -interface en0
  ```

* Windows

  ```bash
  route /p add 0.0.0.0 mask 0.0.0.0 <WARP-CONNECTOR-IP> metric 101
  ```

  Ensure that the `metric` value is lower than other default gateways.

To validate subnet routing, [check your routing table](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#routing-table) and ensure that traffic is routing through the `CloudflareWARP` [virtual interface](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#virtual-interface).

#### Configure DNS resolver on devices

To filter DNS traffic with Cloudflare Gateway, the DNS resolver on your device should point to the shared IP addresses for the Gateway DNS resolver IPs:

* `172.64.36.1`
* `172.64.36.2`

You will also need to [add an IP route](#add-ip-route-to-devices) which routes these Gateway resolver IPs to the WARP Connector host machine.

## 4. Test the WARP Connector

You can now test if traffic from your subnet routes through Cloudflare. For example,

1. On the `10.0.0.2` device, run `curl --ipv4 www.google.com`.
2. Check your [Gateway DNS logs](https://developers.cloudflare.com/cloudflare-one/insights/logs/gateway-logs/) for queries from `warp_connector@<your-team-name>.cloudflareaccess.com`. Logs may take a few minutes to populate.

```mermaid
    flowchart LR
      subgraph subnet1[Subnet 10.0.0.0/24]
        device1["Device
        10.0.0.2"]--Request-->router1["WARP Connector
        10.0.0.1"]
      end
      router1-->C((Cloudflare))-->I{Internet}
```

## Footnotes

1. Check the [system requirements](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/#linux). Package dependencies are the following: `curl`, `gpg`, `iptables`, `iptables-persistent`, `lsb-core`, and `sudo`.

   [↩](#user-content-fnref-1)
