---
title: Protocols for published applications · Cloudflare Zero Trust docs
description: When you add a published application route to a Cloudflare Tunnel,
  you are instructing Cloudflare to proxy requests for your public hostname to a
  service running privately behind cloudflared.  The table below lists the
  service types that can route to a public hostname. Non-HTTP services will
  require installing cloudflared on the client for end users to connect.
lastUpdated: 2025-10-23T19:01:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/protocols/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/protocols/index.md
---

When you [add a published application route](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/#2a-publish-an-application) to a Cloudflare Tunnel, you are instructing Cloudflare to proxy requests for your public hostname to a service running privately behind `cloudflared`. The table below lists the service types that can route to a public hostname. Non-HTTP services will require [installing `cloudflared` on the client](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/cloudflared-authentication/) for end users to connect.

| Service type | Description | Example `service` value |
| - | - | - |
| HTTP | Incoming requests to Cloudflare over HTTPS are proxied to the local web service via HTTP. | `http://localhost:8000` |
| HTTPS | Incoming requests to Cloudflare over HTTPS are proxied directly to the local web service. You can [disable TLS verification](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/configure-tunnels/cloudflared-parameters/origin-parameters/#notlsverify) if your origin uses self-signed certificates. | `https://localhost:8000` |
| UNIX | Just like HTTP, but using a Unix socket instead. | `unix:/home/production/echo.sock` |
| TCP | Enables TCP streams over a Websocket connection. `cloudflared` will take the packets received from the Websocket and reach out to the origin using TCP. To [connect to the public hostname over arbitrary TCP](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/cloudflared-authentication/arbitrary-tcp/), the user needs to run `cloudflared access tcp`, and there are no guarantees on how long the TCP tunnel will live. For long-lived connections, we recommend using [WARP-to-Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/) instead. | `tcp://localhost:2222` |
| SSH | Enables SSH streams over a Websocket connection. `cloudflared` will take the packets received from the Websocket and reach out to the origin using SSH. To [connect to the public hostname over SSH](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-cloudflared-authentication/), the client needs to run `cloudflared access ssh`, and there are no guarantees on how long the SSH connection will last. For long-lived connections, we recommend using [WARP-to-Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) instead. | `ssh://localhost:22` |
| RDP | Similar to TCP but for RDP streams only. For more information, refer to [Connect to RDP with client-side cloudflared](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/rdp/rdp-cloudflared-authentication/). | `rdp://localhost:3389` |
| UNIX + TLS | Just like HTTPS, but using a Unix socket instead. | `unix+tls:/home/production/echo.sock` |
| SMB | Similar to TCP but for SMB streams only. For more information, refer to [Connect to SMB with client-side cloudflared](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/smb/#connect-to-smb-server-with-cloudflared-access). | `smb://localhost:445` |
| HTTP\_STATUS | Responds to all requests with the given HTTP status. | `http_status:404` |
| BASTION | `cloudflared` will act like a jumphost, allowing access to any local address. | `bastion` |
| HELLO\_WORLD | Test server for validating your Cloudflare Tunnel connection (for [locally managed tunnels](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/do-more-with-tunnels/local-management/configuration-file/#file-structure-for-published-applications) only). | `hello_world` |
