---
title: WARP modes · Cloudflare Zero Trust docs
description: You can deploy the WARP client in different modes to control the
  types of traffic sent to Cloudflare Gateway. The WARP mode determines which
  Zero Trust features are available on the device.
lastUpdated: 2025-10-23T22:25:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/index.md
---

You can deploy the WARP client in different modes to control the types of traffic sent to Cloudflare Gateway. The WARP mode determines which Zero Trust features are available on the device.

## Gateway with WARP (default)

This mode is best suited for organizations that want to use advanced firewall/proxy functionalities and enforce device posture rules.

| DNS filtering | Network filtering | HTTP filtering | Features enabled |
| - | - | - | - |
| Yes | Yes | Yes | DNS policies, network policies, HTTP policies, Browser Isolation, identity-based policies, device posture checks, AV scanning, and Data Loss Prevention |

## Gateway with DoH

Gateway with DNS-over-HTTPS (DoH) is best suited for organizations that only want to apply DNS filtering to outbound traffic from their company devices. Network and HTTP traffic is handled by the default mechanisms on your devices.

| DNS filtering | Network filtering | HTTP filtering | Features enabled |
| - | - | - | - |
| Yes | No | No | DNS policies |

## Secure Web Gateway without DNS filtering

Secure Web Gateway without DNS filtering mode (sometimes referred to as tunnel-only mode) is best suited for organizations that want to proxy network and HTTP traffic but keep their existing DNS filtering software. DNS traffic is handled by the default mechanism on your device.

| DNS filtering | Network filtering | HTTP filtering | Features enabled |
| - | - | - | - |
| No | Yes | Yes | Network policies, HTTP policies, Browser Isolation, identity-based policies, device posture checks, AV scanning, and Data Loss Prevention |

Note

* Secure Web Gateway without DNS filtering mode disables all features that rely on WARP for DNS resolution, including [domain-based split tunneling](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#domain-based-split-tunnels) and [Local Domain Fallback](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/local-domains/).
* Only available on Windows, Linux, and macOS.
* Secure Web Gateway without DNS filtering mode has a known limitation concerning [DNS servers with IPv6 addresses](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/known-limitations/#ipv6-dns-resolution-in-secure-web-gateway-without-dns-filtering-mode).

## Proxy mode

Proxy mode is best suited for organizations that want to filter traffic directed to specific applications.

| DNS filtering | Network filtering | HTTP filtering | Features enabled |
| - | - | - | - |
| No | No | Yes | HTTP policies, Browser Isolation, identity-based policies, AV scanning, and Data Loss Prevention for traffic sent through localhost proxy |

### Limitations

* Proxy mode can only be used by applications/operating systems that support SOCKS5/HTTPS proxy communication.
* Requires the MASQUE [device tunnel protocol](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#device-tunnel-protocol). Wireguard is not supported.
* Only available on Windows, Linux, and macOS.
* Proxy mode has a timeout limit of 10 seconds for requests. If a request goes above the 10 second limit, Cloudflare will drop the connection.

## Device Information Only

This mode is best suited for organizations that only want to enforce [WARP client device posture checks](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/) for zones in your account. DNS, Network and HTTP traffic is handled by the default mechanisms on your devices. To setup Device Information Only mode, refer to the [dedicated page](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/device-information-only/).

| DNS filtering | Network filtering | HTTP filtering | Features enabled |
| - | - | - | - |
| No | No | No | Device posture rules in [Access policies](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/) |

## WARP modes comparison

Each WARP mode offers a different set of Zero Trust features.

| WARP Mode | DNS Filtering | Network Filtering | HTTP Filtering | Service mode (displayed in `warp-cli settings`) |
| - | - | - | - | - |
| [**Gateway with WARP (default)**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-warp-default) | ✅ | ✅ | ✅ | `WarpWithDnsOverHttps` |
| [**Gateway with DoH**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#gateway-with-doh) | ✅ | ❌ | ❌ | `DnsOverHttps` |
| [**Secure Web Gateway without DNS filtering**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#secure-web-gateway-without-dns-filtering) | ❌ | ✅ | ✅ | `TunnelOnly` |
| [**Proxy mode**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode) | ❌ | ❌ | ✅ | `WarpProxy on port 40000` |
| [**Device Information Only**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#device-information-only) | ❌ | ❌ | ❌ | `PostureOnly` |

## Related resources

* [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) - Learn about the status messages displayed by the WARP client during its connection process, and understand each stage as WARP establishes a secure tunnel to Cloudflare.
