---
title: Connectivity status · Cloudflare Zero Trust docs
description: The WARP client GUI displays the following status messages when
  transitioning from a Disconnected to Connected state. These messages indicate
  the connectivity stage of the WARP daemon as it establishes a connection from
  the device to Cloudflare. The WARP mode determines which messages are
  displayed during the connection process. If WARP encounters an error while
  connecting, the status message will change to an error code.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/index.md
---

The WARP client GUI displays the following status messages when transitioning from a **Disconnected** to **Connected** state. These messages indicate the connectivity stage of the WARP daemon as it establishes a connection from the device to Cloudflare. The [WARP mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/) determines which messages are displayed during the connection process. If WARP encounters an error while connecting, the status message will change to an [error code](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/client-errors/).

To print status messages to the console, run the `warp-cli -l status` command before turning on the WARP switch.

| Status message | Description |
| - | - |
| Verifying connection settings | Initializes connection components based on your [WARP settings](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/). |
| Validating network | Validates Ethernet and/or Wi-Fi network connectivity. |
| Initializing IP connection | Checks for IPv4 and IPv6 connectivity to Cloudflare using the [Happy Eyeballs algorithm](https://datatracker.ietf.org/doc/html/rfc6555). |
| Establishing a connection | Connects to the endpoint discovered by Happy Eyeballs. |
| Building a Tunnel | Creates a [virtual network interface](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#virtual-interface) on the operating system for the WARP tunnel. |
| Configuring the firewall | Configures the system firewall to allow WARP tunnel traffic. |
| Setting up your routing table | Updates the [system routing table](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#routing-table) based on your [Split Tunnel rules](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/). |
| Configuring your firewall rules | Configures the [system firewall](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#system-firewall) based on your Split Tunnel rules. |
| Checking connectivity to DNS | Checks connectivity to the DNS endpoint (`<account-id>.cloudflare-gateway.com`). |
| Setting local endpoint communication | Configures local DNS proxy sockets. |
| Configuring local DNS proxy | Creates a [local DNS proxy](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#dns-traffic) for DNS resolution. |
| Applying DNS settings | Sets the local DNS proxy as the default DNS server on the device. |
| Configuring forward proxy | (Only in [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode)) Configures the SOCKS proxy. |
| Confirming Tunnel connection | Checks connectivity to [destinations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/firewall/#connectivity-checks) inside and outside of the WARP tunnel. |
| Validating DNS configuration | Verifies that DNS requests are answered by WARP's local DNS proxy. |
| Verifying SOCKS proxy configuration | (Only in [Proxy mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/#proxy-mode)) Verifies the SOCKS proxy configuration. |
| Ensuring MTLS identity | (Only in [Device Information Only mode](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-modes/device-information-only/)) Installs a client certificate for mTLS authentication. |
