---
title: Set up network filtering · Cloudflare Zero Trust docs
description: Secure Web Gateway allows you to apply policies at the network
  level (Layers 3 and 4) to control which websites and non-HTTP applications
  users can access.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/network/
  md: https://developers.cloudflare.com/cloudflare-one/traffic-policies/initial-setup/network/index.md
---

Secure Web Gateway allows you to apply policies at the network level (Layers 3 and 4) to control which websites and non-HTTP applications users can access.

Note

For a more detailed guide to filtering network traffic and more for your organization, refer to the [Secure your Internet traffic and SaaS apps](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/concepts/) implementation guide.

## 1. Connect to Gateway

### Connect devices

To filter network traffic from a device such as a laptop or phone:

1. [Install the WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on your device.
2. In the WARP client Settings, log in to your organization's Zero Trust instance.
3. (Optional) If you want to display a [custom block page](https://developers.cloudflare.com/cloudflare-one/traffic-policies/block-page/), [install the Cloudflare root certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) on your device .
4. [Enable the Gateway proxy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/#turn-on-the-gateway-proxy) for TCP. Optionally, you can enable the UDP proxy to inspect all port 443 UDP traffic.

### Connect private networks

To filter traffic from private networks, refer to the [Cloudflare Tunnel guide](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/).

## 2. Verify device connectivity

To verify your device is connected to Zero Trust:

1. In [Zero Trust](https://one.dash.cloudflare.com), go to **Settings** > **Network**.

2. Under **Gateway logging**, enable activity logging for all Network logs.

3. On your WARP-enabled device, open a browser and visit any website.

4. Determine the **Source IP** for your device:

   1. Open the WARP client settings.
   2. Go to **Preferences** > **General**.
   3. Note the **Public IP**.

5. In Zero Trust, go to **Logs** > **Gateway** > **Network**. Before building Network policies, make sure you see Network logs from the Source IP assigned to your device.

## 3. Create your first network policy

To create a new network policy:

* Dashboard

  1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Gateway** > **Firewall policies**.

  2. In the **Network** tab, select **Add a policy**.

  3. Name the policy.

  4. Under **Traffic**, build a logical expression that defines the traffic you want to allow or block.

  5. Choose an **Action** to take when traffic matches the logical expression. For example, you can use a list of [device serial numbers](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/corp-device/) to ensure users can only access an application if they connect with the WARP client from a company device:

     | Selector | Operator | Value | Logic | Action |
     | - | - | - | - | - |
     | SNI Domain | is | `internalapp.com` | And | Block |
     | Passed Device Posture Checks | not in | *Device serial numbers* | | |

  6. Select **Create policy**.

* API

  1. [Create an API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) with the following permissions:

     | Type | Item | Permission |
     | - | - | - |
     | Account | Zero Trust | Edit |

  2. (Optional) Configure your API environment variables to include your [account ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) and API token.

  3. Send a `POST` request to the [Create a Zero Trust Gateway rule](https://developers.cloudflare.com/api/resources/zero_trust/subresources/gateway/subresources/rules/methods/create/) endpoint. For example, you can use a list of [device serial numbers](https://developers.cloudflare.com/cloudflare-one/reusable-components/posture-checks/warp-client-checks/corp-device/) to ensure users can only access an application if they connect with the WARP client from a company device:

     Required API token permissions

     At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

     * `Zero Trust Write`

     ```bash
     curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/gateway/rules" \
       --request POST \
       --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
       --json '{
         "name": "Enforce device posture",
         "description": "Ensure only devices in Zero Trust organization can connect to application",
         "precedence": 0,
         "enabled": true,
         "action": "block",
         "filters": [
             "l4"
         ],
         "traffic": "any(net.sni.domains[*] == \"internalapp.com\")",
         "identity": "",
         "device_posture": "not(any(device_posture.checks.passed[*] in {\"LIST_UUID\"}))"
       }'
     ```

  ```sh
  {
     "success": true,
     "errors": [],
     "messages": []
  }
  ```

  The API will respond with a summary of the policy and the result of your request.

For more information, refer to [network policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/).

## 4. Add optional policies

Refer to our list of [common network policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/common-policies) for policies you may want to create.
