---
title: Get Started — Regional Services · Cloudflare Data Localization Suite docs
description: You can use Regional Services through the dashboard or via API.
lastUpdated: 2025-10-09T10:07:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/data-localization/regional-services/get-started/
  md: https://developers.cloudflare.com/data-localization/regional-services/get-started/index.md
---

Note

Interested customers need to contact their account team to enable DNS Regionalisation.

You can use Regional Services through the dashboard or via API.

## Configure Regional Services in the dashboard

To use Regional Services, you need to first create a DNS record in the dashboard:

1. In the Cloudflare dashboard, go to the **Records** page.

   [Go to **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records)

2. Follow these steps to [create a DNS record](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/).

3. From the **Region** dropdown, select the region you would like to use on your domain. This value will be applied to all DNS records on the same hostname. This means that if you have two DNS records of the same hostname and change the region for one of them, both records will have the same region.

Note

Some regions may not appear on the dropdown because newly announced regions mentioned in the [blog post](https://blog.cloudflare.com/expanding-regional-services-configuration-flexibility-for-customers) are subject to approval by Cloudflare's internal team. For more information and entitlement reach out to your account team.

Refer to the table on [Available regions and product support](https://developers.cloudflare.com/data-localization/region-support/) for the complete list of available regions, their definitions and product support

## Configure Regional Services via API

You can also use Regional Services via API.

Currently, only SuperAdmins and Admin roles can edit DLS configurations. Use the Zone-level **DNS: Read/Write** API permission for the `/addressing/` endpoint to read or write Regional Services configurations.

These are some examples of API requests.

List all the available regions

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Read`
* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/accounts/$ACCOUNT_ID/addressing/regional_hostnames/regions" \
  --request GET \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
 "success": true,
 "errors": [],
 "result": [
  {
   "key": "ca",
   "label": "Canada"
  },
  {
   "key": "eu",
   "label": "Europe"
  }
 ],
 "messages": []
}
```

Create a new regional hostname entry

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/addressing/regional_hostnames" \
  --request POST \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "hostname": "ca.regional.ipam.rocks",
    "region_key": "ca"
  }'
```

```json
{
 "success": true,
 "errors": [],
 "result": {
  "hostname": "ca.regional.ipam.rocks",
  "region_key": "ca",
  "created_on": "2023-01-13T23:59:45.276558Z"
 },
 "messages": []
}
```

List all regional hostnames for a zone or get a specific one

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Read`
* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/addressing/regional_hostnames" \
  --request GET \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
 "success": true,
 "errors": [],
 "result": [
  {
   "hostname": "ca.regional.ipam.rocks",
   "region_key": "ca",
   "created_on": "2023-01-14T00:47:57.060267Z"
  }
 ],
 "messages": []
}
```

List all regional hostnames for a specific zone

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Read`
* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/addressing/regional_hostnames/$HOSTNAME" \
  --request GET \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
 "success": true,
 "errors": [],
 "result": {
  "hostname": "ca.regional.ipam.rocks",
  "region_key": "ca",
  "created_on": "2023-01-13T23:59:45.276558Z"
 },
 "messages": []
}
```

Patch the region for a specific hostname

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/addressing/regional_hostnames/$HOSTNAME" \
  --request PATCH \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "region_key": "eu"
  }'
```

```json
{
 "success": true,
 "errors": [],
 "result": {
  "hostname": "ca.regional.ipam.rocks",
  "region_key": "eu",
  "created_on": "2023-01-13T23:59:45.276558Z"
 },
 "messages": []
}
```

Delete the region configuration

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `DNS Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/addressing/regional_hostnames/$HOSTNAME" \
  --request DELETE \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
```

```json
{
 "success": true,
 "errors": [],
 "result": null,
 "messages": []
}
```

## Terraform support

You can also configure Regional Services using Terraform. For more details, refer to the [`cloudflare_regional_hostname` resource](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/regional_hostname) in the Terraform documentation.
