---
title: Dispositions and attributes · Cloudflare Email Security (formerly Area 1) docs
description: Email Security uses a variety of factors to determine whether a
  given email message, domain, URL, or packet is part of a phishing campaign.
  These small pattern assessments are dynamic in nature and — in many cases — no
  single pattern will determine the final verdict.
lastUpdated: 2025-08-29T19:00:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/email-security/reference/dispositions-and-attributes/
  md: https://developers.cloudflare.com/email-security/reference/dispositions-and-attributes/index.md
---

Area 1 has been renamed

Area 1 is now **Email Security (formerly Area 1)**.

Access to Area 1

Beginning October 1, 2025, access and support for Email Security (formerly Area 1) will only be available through the Cloudflare dashboard. Your Email Security protection will not change, but you will no longer be able to access the Area 1 dashboard or send support requests to `@area1security.com` email addresses. For help accessing the Cloudflare dashboard, reach out to <successteam@cloudflare.com>.

Email Security uses a variety of factors to determine whether a given email message, domain, URL, or packet is part of a phishing campaign. These small pattern assessments are dynamic in nature and — in many cases — no single pattern will determine the final verdict.

Based on these patterns, Email Security may add `X-Headers` to each email message that passes through our system.

## Dispositions

Any traffic that flows through Email Security is given a final disposition, which represents our evaluation of that specific message. Each message will only receive one disposition header so your organization can take clear and specific actions on different message types.

You can use disposition values when [creating your quarantine policy](https://developers.cloudflare.com/email-security/email-configuration/domains-and-routing/domains/) or [setting up auto-retract](https://developers.cloudflare.com/email-security/email-configuration/retract-settings/).

### Available values

| Disposition | Description | Recommendation |
| - | - | - |
| `MALICIOUS` | Traffic invoked multiple phishing verdict triggers, met thresholds for bad behavior, and is associated with active campaigns. | Block |
| `SUSPICIOUS` | Traffic associated with phishing campaigns (and is under further analysis by our automated systems). | Research these messages internally to evaluate legitimacy. |
| `SPOOF` | Traffic associated with phishing campaigns that is either non-compliant with your email authentication policies (SPF, DKIM, DMARC) or has mismatching `Envelope From` and `Header From` values. | Block after investigating (can be triggered by third-party mail services). |
| `UCE` (Unsolicited Commercial Emails) | Traffic associated with non-malicious, commercial campaigns. | Route to existing Spam quarantine folder. |
| `BULK` (dashboard only) | Traffic often associated with newsletters or marketing campaigns. Refer to [Graymail](https://en.wikipedia.org/wiki/Graymail_%28email%29) for more details. | Monitor or tag |

### Header structure

When Email Security adds a disposition header to an email message, that header matches the following format:

```txt
X-Area1Security-Disposition: [Value]
```

Note that emails with a disposition of `SPAM` will be tagged with `UCE` (unsolicited commercial emails) in their headers:

```txt
X-Area1Security-Disposition: UCE
```

## Attributes

Traffic that flows through Email Security can also receive one or more **Attributes**, which indicate that a specific condition has been met.

### Available values

| Attribute | Notes |
| - | - |
| `CUSTOM_BLOCK_LIST` | This message matches a value you have defined in your custom block list. |
| `NEW_DOMAIN_SENDER=<REGISTRATION_DATE>` | Alerts to mail from a newly registered domain. Formatted as yyyy-MM-dd HH:mm:ss ZZZ. |
| `NEW_DOMAIN_LINK=<REGISTRATION_DATE>` | Alerts to mail with links pointing out to a newly registered domain. Formatted as yyyy-MM-dd HH:mm:ss ZZZ. |
| `ENCRYPTED` | Email message is encrypted. |
| `EXECUTABLE` | Email message contains an executable file. |
| `BEC` | Indicates that email address was contained in your [business email compromise (BEC)](https://developers.cloudflare.com/email-security/email-configuration/enhanced-detections/business-email-compromise/) list. Associated with `MALICIOUS` or `SPOOF` dispositions. |

### Header structure

When Email Security adds a disposition header to an email message, that header matches the following format.

```txt
X-Area1Security-Attribute: [Value]
X-Area1Security-Attribute: [Value2]
```
