---
title: Compliance documentation · Cloudflare Fundamentals docs
description: Super Administrators can access common compliance documentation,
  such as PCI, SOC 2, ISO, and more, through the Cloudflare dashboard.
lastUpdated: 2025-08-22T16:55:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/reference/policies-compliances/compliance-docs/
  md: https://developers.cloudflare.com/fundamentals/reference/policies-compliances/compliance-docs/index.md
---

Super Administrators can access common compliance documentation, such as PCI, SOC 2, ISO, and more, through the Cloudflare dashboard.

To access compliance documentation:

1. Visit [Compliance Documents](https://dash.cloudflare.com/?to=/:account/compliance-docs) and select your account where you are a **Super Administrator**.
2. If you have not accessed this page before, read the confidentiality statement and select **I Agree**.
3. Choose the document you need and select **Download**.

Note

For confidentiality purposes, only **Super Administrators** for an account can access compliance documentation.

## Public data protection and compliance documentation

Information and documents about Cloudflare's privacy & data protection are available on our public website at [cloudflare.com/trust-hub/](https://www.cloudflare.com/trust-hub/).

On the [Trust Hub](https://www.cloudflare.com/trust-hub/), you will find information & documents related to:

* Privacy Policy
* Data Processing Addendum (DPA)
* Europe General Data Protection Regulation (GDPR)
* Brazil General Data Protection Law (LGPD)
* Japan Act on the Protection of Personal Information (APPI)
* Singapore Personal Data Protection Act (PDPA)
* South Korea Personal Information Protection Act (PIPA)
* India Digital Personal Data Protection Bill (DPDP)
* Australia Privacy Act
* United States California Consumer Privacy Act (CCPA) & Consumer Privacy Rights Act (CPRA)
* EU Digital Operational Resilience Act (DORA)
* ISO 27001:2022
* ISO 27701:2019
* ISO 27018:2019
* FedRAMP Moderate
* SOC 2 Type II
* PCI DSS 4.0
* Global CBPR
* Global PRP
* EU Cloud Code of Conduct
* Cyber Essentials
* C5:2020
* ENS
* IRAP
* BSI Qualification
* WCAG 2.1 AA and Section 508

## Tax documentation

Super Administrators, Billing Administrators, and Administrators can access tax documentation, such W-9 and Tax Certificates, through the Cloudflare dashboard.

To access tax documentation:

1. Visit [Tax Documents](https://dash.cloudflare.com/?to=/:account/tax-docs) and select your account where you are a **Super Administrator**, **Billing Administrator** or **Administrator**.
2. Choose the document you need and select **Download**.
