---
title: Proxy traffic through Gateway · Cloudflare Learning Paths
description: With Cloudflare Gateway, you can log and filter DNS, network, and
  HTTP traffic from devices running the WARP client. This includes traffic to
  the public Internet and traffic directed to your private network. DNS
  filtering is enabled by default since the WARP client sends DNS queries to
  Cloudflare's public DNS resolver, 1.1.1.1. To enable network and HTTP
  filtering, you will need to allow Cloudflare Gateway to proxy that traffic.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/enable-proxy/
  md: https://developers.cloudflare.com/learning-paths/replace-vpn/configure-device-agent/enable-proxy/index.md
---

With Cloudflare Gateway, you can log and filter DNS, network, and HTTP traffic from devices running the WARP client. This includes traffic to the public Internet and traffic directed to your private network. DNS filtering is enabled by default since the WARP client sends DNS queries to Cloudflare's public DNS resolver, [1.1.1.1](https://developers.cloudflare.com/1.1.1.1/). To enable network and HTTP filtering, you will need to allow Cloudflare Gateway to proxy that traffic.

## Enable the proxy

To start logging and filtering network traffic, turn on the Gateway proxy:

* Dashboard

  1. Go to **Settings** > **Network**.
  2. In **Firewall**, turn on **Proxy**.
  3. Select **TCP**.
  4. (Recommended) To proxy traffic to internal DNS resolvers, select **UDP**.
  5. (Recommended) To proxy traffic for diagnostic tools such as `ping` and `traceroute`, select **ICMP**. You may also need to [update your system](https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/#icmp) to allow ICMP traffic through `cloudflared`.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Turn on the TCP and/or UDP proxy using the [`cloudflare_zero_trust_device_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_device_settings) resource:

     ```tf
     resource "cloudflare_zero_trust_device_settings "global_warp_settings" {
       account_id            = var.cloudflare_account_id
       gateway_proxy_enabled = true
       gateway_udp_proxy_enabled = true
     }
     ```

Cloudflare will now proxy traffic from enrolled devices, except for the traffic excluded in your [split tunnel settings](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/#3-route-private-network-ips-through-warp). For more information on how Gateway forwards traffic, refer to [Gateway proxy](https://developers.cloudflare.com/cloudflare-one/traffic-policies/proxy/).
