---
title: Logpush · Cloudflare Logs docs
description: Logpush delivers logs in batches as quickly as possible, with no
  minimum batch size, potentially delivering files more than once per minute.
  This capability enables Cloudflare to provide information almost in real time,
  in smaller file sizes. Users can configure the batch size using the API for
  improved control in case the log destination has specific requirements.
lastUpdated: 2025-07-24T13:05:17.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/
  md: https://developers.cloudflare.com/logs/logpush/index.md
---

Logpush delivers logs in batches as quickly as possible, with no minimum batch size, potentially delivering files more than once per minute. This capability enables Cloudflare to provide information almost in real time, in smaller file sizes. Users can configure the batch size [using the API](https://developers.cloudflare.com/logs/logpush/logpush-job/api-configuration/#max-upload-parameters) for improved control in case the log destination has specific requirements.

Logpush does not offer storage or search functionality for logs; its primary aim is to send logs as quickly as they arrive.

Cloudflare Logpush supports pushing logs to storage services, SIEMs, and log management providers via the Cloudflare dashboard or API.

Cloudflare aims to support additional services in the future. Interested in a particular service? Take this [survey](https://goo.gl/forms/0KpMfae63WMPjBmD2).

## Limits

There is currently a max limit of **4 Logpush jobs per zone**. Trying to create a job once the limit has been reached will result in an error message: `creating a new job is not allowed: exceeded max jobs allowed`.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | No | No | No | Yes |

Note

Users without an Enterprise plan can still access [Workers Trace Events Logpush](https://developers.cloudflare.com/workers/observability/logs/logpush/) by subscribing to the [Workers Paid](https://developers.cloudflare.com/workers/platform/pricing/) plan.
