---
title: Cloudflare IPs · Cloudflare Magic Transit docs
description: To use Magic Transit you need to own a publicly routable IP address
  block with a minimum size of /24. If you do not own a /24 address block, you
  can use Magic Transit with a Cloudflare-owned IP address. This option is
  helpful for users who do not meet the /24 prefix length requirements or who
  want to protect a smaller network.
lastUpdated: 2025-10-01T13:13:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/magic-transit/cloudflare-ips/
  md: https://developers.cloudflare.com/magic-transit/cloudflare-ips/index.md
---

To use Magic Transit you need to own a publicly routable IP address block with a minimum size of `/24`. If you do not own a `/24` address block, you can use Magic Transit with a Cloudflare-owned IP address. This option is helpful for users who do not meet the `/24` prefix length requirements or who want to protect a smaller network.

To protect your network using a Cloudflare IP address, contact your account manager. After receiving your IP address, you will need to:

* [Create a tunnel](https://developers.cloudflare.com/magic-transit/how-to/configure-tunnel-endpoints/).
* [Set up static routes](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-static-routes) or [BGP peering](https://developers.cloudflare.com/magic-transit/how-to/configure-routes/#configure-bgp-routes).
* [Configure health checks](https://developers.cloudflare.com/magic-transit/network-health/run-endpoint-health-checks/).
* Confirm [tunnel](https://developers.cloudflare.com/magic-transit/network-health/update-tunnel-health-checks-frequency/) and endpoint health checks were properly configured.
* Update your infrastructure at your own pace to use the allocated Cloudflare IPs.

When you use a Cloudflare-owned IP space, you do not need a Letter of Agency (LOA). When using Cloudflare-leased IPs, [Magic Transit Egress](https://developers.cloudflare.com/magic-transit/reference/egress/) is automatically enabled — that is, your egress traffic will also be destined to Cloudflare instead of the Internet. Because of this, you will need to set up policy-based routing on your end to make sure that return traffic is properly routed.

## Check your Cloudflare IPs

A list of your leased Anycast IPs for Magic Transit is available on the dashboard under [**IP addresses** > **Leased IPs**](https://dash.cloudflare.com/?to=/:account/ip-addresses/leased-ips).
