---
title: Application Security reports · Cloudflare Security Center docs
description: Application Security reports provide cyber attack insights and
  trends for all of the Enterprise zones in your Cloudflare account.
lastUpdated: 2025-10-17T15:40:31.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/app-security-reports/
  md: https://developers.cloudflare.com/security-center/app-security-reports/index.md
---

Application Security reports provide cyber attack insights and trends for all of the Enterprise zones in your Cloudflare account.

The reports are automatically generated on a monthly basis.

You can access reports by going to the **Security reports** page. You can access reports from previous months by selecting the month from the dropdown.

[Go to **Security reports**](https://dash.cloudflare.com/?to=/:account/security-center/reports)

To download the report, select **Print report**.

Reports from before April 2025 can be accessed through **Security reports** > **Legacy reports**. Due to limitations in the legacy reports, some customers may not have reports for every month prior to April 2025.

The current reports are curated by Cloudflare and will be expanded to include more insights. The option to create custom reports, filter by various fields, and schedule reports will be added in upcoming improvements.

***

## Report types

Currently, only Application Security reports are available. They cover the entire suite of products such as [HTTP DDoS Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/), [WAF](https://developers.cloudflare.com/waf/), and [Bot Management](https://developers.cloudflare.com/bots/).

Reports for Application Performance, [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/), and Network Services, such as [Magic Transit](https://developers.cloudflare.com/magic-transit/), will be made available in future improvements.

***

## Report layout

Each report includes the following sections:

* Executive summary
* Distribution of allowed and mitigated requests
* [Industry benchmarks](#industry-benchmarks) that show how you compare to your peers by selecting your industry
* Top five source countries of allowed traffic and mitigated traffic including a map visualization
* Top five most targeted hostnames
* Top five most effective mitigation rules

To view more details, apply filters, analyze the data, and generate ad-hoc reports, use the [Security Analytics dashboard](https://developers.cloudflare.com/waf/analytics/security-analytics/) or [Log Explorer](https://developers.cloudflare.com/log-explorer/).

### Industry benchmarks

If your account is not assigned an industry or if the shown industry is incorrect, use the link within the report to select the correct industry.

It may take a while for your new selection to take effect, and it may only be applied to future reports.

If you have multiple Cloudflare accounts, select the industry that is most relevant for the specific account.

***

## Prerequisites

You must have at least one Enterprise zone. Application Security reports are automatically enabled on your Enterprise zone. No action is required.

If you do not have any Enterprise zones, a report will not be generated. If you have an account that is not older than one month, a report will not be generated yet.

### Required roles

A Cloudflare user must have one of the following [roles](https://developers.cloudflare.com/fundamentals/manage-members/roles/) to download Application Security reports:

* Super Administrator
* Administrator

***

## Limitations

Application Security reports currently only support US Customer Metadata Boundary (CMB). They do not support the EU CMB yet.

***

## Availability

This feature is available in closed beta to Enterprise customers.
