---
title: Azure Dedicated HSM · Cloudflare SSL/TLS docs
description: Learn how to use Keyless SSL with Azure Dedicated HSM.
lastUpdated: 2025-10-09T15:47:46.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/keyless-ssl/hardware-security-modules/azure-dedicated-hsm/
  md: https://developers.cloudflare.com/ssl/keyless-ssl/hardware-security-modules/azure-dedicated-hsm/index.md
---

This tutorial uses [Azure Dedicated HSM](https://azure.microsoft.com/en-us/services/azure-dedicated-hsm/) — a FIPS 140-2 Level 3 certified implementation based on the Gemalto SafeNet Luna a790.

***

## Before you start

Make sure you have:

* Followed Microsoft's [tutorial](https://docs.microsoft.com/en-us/azure/dedicated-hsm/tutorial-deploy-hsm-powershell) for deploying HSMs into an existing virtual network using PowerShell
* Installed the [SafeNet client software](https://cpl.thalesgroup.com/node/11350)

***

## 1. Create, assign, and initialize a new partition

The first step is creating an HSM partition, which can be thought of as an independent logical HSM within your Azure Dedicated HSM device.

```txt
vm$ ssh tenantadmin@hsm


[local_host] lunash:>hsm login
  Please enter the HSM Administrators' password:
  > ********




'hsm login' successful.




Command Result : 0 (Success)


[local_host] lunash:>partition create -partition KeylessSSL




          Type 'proceed' to create the partition, or
          'quit' to quit now.
          > proceed
'partition create' successful.




Command Result : 0 (Success)
```

Next, the partition needs to be assigned to the client, in this case your key server.

```bash
[local_host] lunash:>client assignpartition -client azure-keyless -partition KeylessSSL




'client assignPartition' successful.




Command Result : 0 (Success)
```

After the partition has been assigned, run `lunacm` from your virtual server and initialize the partition.

```txt
vm$ lunacm
lunacm (64-bit) v7.2.0-220. Copyright (c) 2018 SafeNet. All rights reserved.




  Available HSMs:


  Slot Id ->              0
  Label ->
  Serial Number ->        XXXXXXXXXXXXX
  Model ->                LunaSA 7.2.0
  Firmware Version ->     7.0.3
  Configuration ->        Luna User Partition With SO (PW) Signing With Cloning Mode
  Slot Description ->     Net Token Slot




  Current Slot Id: 0


lunacm:>partition init -label KeylessSSL -domain cloudflare


  Enter password for Partition SO: ********


  Re-enter password for Partition SO: ********


  You are about to initialize the partition.
  All contents of the partition will be destroyed.


  Are you sure you wish to continue?


  Type 'proceed' to continue, or 'quit' to quit now ->proceed


Command Result : No Error
```

***

## 2. Generate a RSA key pair and certificate signing request (CSR)

Before running the commands below, check with your information security and/or cryptography team to confirm the approved key creation procedures for your organization.

```txt
# cmu generatekeypair -keyType=RSA -modulusBits=2048 -publicExponent=65537 -sign=1 -verify=1 -labelpublic=myrsakey -labelprivate=myrsakey -keygenmech=1


Please enter password for token in slot 0 : ********


# cmu list


Please enter password for token in slot 0 : ********
handle=51 label=myrsakey
handle=48 label=myrsakey
```

Using the key created in the previous step, generate a CSR that can be sent to a publicly trusted Certificate Authority (CA) for signing.

```txt
# cmu requestCertificate -c="US" -o="Example, Inc." -cn="azure-dedicatedhsm.example.com" -s="California" -l="San Francisco" -publichandle=48 -privatehandle=51 -outputfile="rsa.csr" -sha256withrsa


Please enter password for token in slot 0 : ********
Using "CKM_SHA256_RSA_PKCS" Mechanism
```

***

## 3. Obtain and upload a signed certificate from your Certificate Authority (CA)

Provide the CSR created in the previous step to your organization's preferred CA, demonstrate control of your domain as requested, and then download the signed SSL certificates. Follow the instructions provided in [Upload Keyless SSL Certificates](https://developers.cloudflare.com/ssl/keyless-ssl/configuration/cloudflare-tunnel/#3-upload-keyless-ssl-certificates).

***

## 4. Modify your gokeyless config file and restart the service

Lastly, we need to modify the configuration file that the key server will read on startup. Be sure to change the `object=mykey` and `pin-value=username:password` values to match the key label you provided and CU user you created.

Open `/etc/keyless/gokeyless.yaml` and immediately after:

```yaml
private_key_stores:
  - dir: /etc/keyless/keys
```

add:

```yaml
- uri: pkcs11:token=KeylessSSL;object=myrsakey?module-path=/usr/safenet/lunaclient/lib/libCryptoki2_64.so&pin-value=password&max-sessions=1
```

With the config file saved, restart `gokeyless` and verify it started successfully.

```sh
sudo systemctl restart gokeyless.service
sudo systemctl status gokeyless.service -l
```
