---
title: Overview · Cloudflare Workers AI docs
description: Workers AI allows you to run AI models in a serverless way, without
  having to worry about scaling, maintaining, or paying for unused
  infrastructure. You can invoke models running on GPUs on Cloudflare's network
  from your own code — from Workers, Pages, or anywhere via the Cloudflare API.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/workers-ai/
  md: https://developers.cloudflare.com/workers-ai/index.md
---

Run machine learning models, powered by serverless GPUs, on Cloudflare's global network.

Available on Free and Paid plans

Workers AI allows you to run AI models in a serverless way, without having to worry about scaling, maintaining, or paying for unused infrastructure. You can invoke models running on GPUs on Cloudflare's network from your own code — from [Workers](https://developers.cloudflare.com/workers/), [Pages](https://developers.cloudflare.com/pages/), or anywhere via [the Cloudflare API](https://developers.cloudflare.com/api/resources/ai/methods/run/).

Workers AI gives you access to:

* **50+ [open-source models](https://developers.cloudflare.com/workers-ai/models/)**, available as a part of our model catalog
* Serverless, **pay-for-what-you-use** [pricing model](https://developers.cloudflare.com/workers-ai/platform/pricing/)
* All as part of a **fully-featured developer platform**, including [AI Gateway](https://developers.cloudflare.com/ai-gateway/), [Vectorize](https://developers.cloudflare.com/vectorize/), [Workers](https://developers.cloudflare.com/workers/) and more...

[Get started](https://developers.cloudflare.com/workers-ai/get-started)

[Watch a Workers AI demo](https://youtu.be/cK_leoJsBWY?si=4u6BIy_uBOZf9Ve8)

Custom requirements

If you have custom requirements like private custom models or higher limits, complete the [Custom Requirements Form](https://forms.gle/axnnpGDb6xrmR31T6). Cloudflare will contact you with next steps.

Workers AI is now Generally Available

To report bugs or give feedback, go to the [#workers-ai Discord channel](https://discord.cloudflare.com). If you are having issues with Wrangler, report issues in the [Wrangler GitHub repository](https://github.com/cloudflare/workers-sdk/issues/new/choose).

***

## Features

### Models

Workers AI comes with a curated set of popular open-source models that enable you to do tasks such as image classification, text generation, object detection and more.

[Browse models](https://developers.cloudflare.com/workers-ai/models/)

***

## Related products

**[AI Gateway](https://developers.cloudflare.com/ai-gateway/)**

Observe and control your AI applications with caching, rate limiting, request retries, model fallback, and more.

**[Vectorize](https://developers.cloudflare.com/vectorize/)**

Build full-stack AI applications with Vectorize, Cloudflare’s vector database. Adding Vectorize enables you to perform tasks such as semantic search, recommendations, anomaly detection or can be used to provide context and memory to an LLM.

**[Workers](https://developers.cloudflare.com/workers/)**

Build serverless applications and deploy instantly across the globe for exceptional performance, reliability, and scale.

**[Pages](https://developers.cloudflare.com/pages/)**

Create full-stack applications that are instantly deployed to the Cloudflare global network.

**[R2](https://developers.cloudflare.com/r2/)**

Store large amounts of unstructured data without the costly egress bandwidth fees associated with typical cloud storage services.

**[D1](https://developers.cloudflare.com/d1/)**

Create new serverless SQL databases to query from your Workers and Pages projects.

**[Durable Objects](https://developers.cloudflare.com/durable-objects/)**

A globally distributed coordination API with strongly consistent storage.

**[KV](https://developers.cloudflare.com/kv/)**

Create a global, low-latency, key-value data storage.

***

## More resources

[Get started](https://developers.cloudflare.com/workers-ai/get-started/workers-wrangler/)

Build and deploy your first Workers AI application.

[Plans](https://developers.cloudflare.com/workers-ai/platform/pricing/)

Learn about Free and Paid plans.

[Limits](https://developers.cloudflare.com/workers-ai/platform/limits/)

Learn about Workers AI limits.

[Use cases](https://developers.cloudflare.com/use-cases/ai/)

Learn how you can build and deploy ambitious AI applications to Cloudflare's global network.

[Storage options](https://developers.cloudflare.com/workers/platform/storage-options/)

Learn which storage option is best for your project.

[Developer Discord](https://discord.cloudflare.com)

Connect with the Workers community on Discord to ask questions, share what you are building, and discuss the platform with other developers.

[@CloudflareDev](https://x.com/cloudflaredev)

Follow @CloudflareDev on Twitter to learn about product announcements, and what is new in Cloudflare Workers.
