---
title: Zaraz Context · Cloudflare Zaraz docs
description: The Zaraz Context is a versatile object that provides a set of
  configurable properties for Zaraz, a web analytics tool for tracking user
  behavior on websites. These properties can be accessed and utilized across
  various components, including Worker Variables and JSONata expressions.
lastUpdated: 2025-03-07T11:07:33.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/zaraz/reference/context/
  md: https://developers.cloudflare.com/zaraz/reference/context/index.md
---

The Zaraz Context is a versatile object that provides a set of configurable properties for Zaraz, a web analytics tool for tracking user behavior on websites. These properties can be accessed and utilized across various components, including [Worker Variables](https://developers.cloudflare.com/zaraz/variables/worker-variables/) and [JSONata expressions](https://developers.cloudflare.com/zaraz/advanced/using-jsonata/).

System properties, which are automatically collected by Zaraz, provide insights into the user's environment and device, while Client properties, obtained through [Zaraz Web API](https://developers.cloudflare.com/zaraz/web-api/) calls like zaraz.track(), offer additional information on user behavior and actions.

## System properties

### Page information

| Property | Type | Description |
| - | - | - |
| `system.page.query` | Object | Key-Value object containing all query parameters in the current URL. |
| `system.page.title` | String | Current page title. |
| `system.page.url` | URL | [URL](https://developer.mozilla.org/en-US/docs/Web/API/URL) Object containing information about the current URL |
| `system.page.referrer` | String | Current page referrer from `document.referrer`. |
| `system.page.encoding` | String | Current page character encoding from `document.characterSet`. |
| | | |

### Cookies

| Property | Type | Description |
| - | - | - |
| `system.cookies` | Object | Key-Value object containing all present cookies. |

The keys inside the `system.cookies` are the cookies name. The property `system.cookies.foo` will return the value of the a cookie named `foo`.

### Device information

| Property | Type | Description |
| - | - | - |
| `system.device.ip` | String | Visitor incoming IP address. |
| `system.device.resolution` | String | Screen resolution for device. |
| `system.device.viewport` | String | Visible web page area in user’s device. |
| `system.device.language` | String | Language used in user's device. |
| `system.device.location` | Object | All location-related keys from [IncomingRequestCfProperties](https://developers.cloudflare.com/workers/runtime-apis/request/#incomingrequestcfproperties) |
| `system.device.user-agent.ua` | String | Browser user agent. |
| `system.device.user-agent.browser.name` | String | Browser name. |
| `system.device.user-agent.browser.version` | String | Browser version. |
| `system.device.user-agent.engine.name` | String | Type of browser engine (for example, WebKit). |
| `system.device.user-agent.engine.version` | String | Version of the browser engine. |
| `system.device.user-agent.os.name` | String | Operating system. |
| `system.device.user-agent.os.version` | String | Version of the operating system. |
| `system.device.user-agent.device` | String | Type of device used (for example, iPhone). |
| `system.device.user-agent.cpu` | String | Device’s CPU. |
| | | |

### Consent Management

| Property | Type | Description |
| - | - | - |
| `system.consent` | Object | Key-value object containing the current consent status from the Zaraz Consent Manager. |

The keys inside the `system.consent` object are purpose IDs, and values are `true` for consent, `false` for lack of consent.

### Managed Components

| Property | Type | Description |
| - | - | - |
| `system.clientKV` | Object | Key-value object containing all the KV data from your Managed Components. |

The keys inside the `system.clientKV` object are formatted as Tool ID, underscore, Key name. Assuming you want to read the value of the `ga4` key used by a tool with ID `abcd`, the path would be `system.clientKV.abcd_ga4`.

### Miscellaneous

| Property | Type | Description |
| - | - | - |
| `system.misc.random` | Number | Random number unique to each request. |
| `system.misc.timestamp` | Number | Unix time in seconds. |
| `system.misc.timestampMilliseconds` | Number | Unix time in milliseconds. |
| | | |

## Event properties

| Property | Type | Description |
| - | - | - |
| `client.__zarazTrack` | String | Returns the name of the event sent using the Track method of the Web API. Refer to [Zaraz Track](https://developers.cloudflare.com/zaraz/web-api/track/) for more information. |
| `client.<KEY_NAME>` | String | Returns the value of a `zaraz.track()` `eventProperties` key. The key can either be directly used in `zaraz.track()` or set using `zaraz.set()`. Replace `<KEY_NAME>` with the name of your key. Refer to [Zaraz Track](https://developers.cloudflare.com/zaraz/web-api/track/) for more information. |
| | | |
